/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.block.entity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.me.helpers.MachineSource;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import io.github.projectet.ae2things.AE2Things;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class BEAdvancedInscriber
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject {
    private final AppEngInternalInventory topItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory botItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 1, 64);
    private final AppEngInternalInventory sideItemHandler = new AppEngInternalInventory((InternalInventoryHost)this, 2, 64);
    private final Map<InternalInventory, ItemStack> lastStacks = new IdentityHashMap<AppEngInternalInventory, ItemStack>(Map.of(this.topItemHandler, ItemStack.f_41583_, this.botItemHandler, ItemStack.f_41583_, this.sideItemHandler, ItemStack.f_41583_));
    private final InternalInventory topItemHandlerExtern;
    private final InternalInventory botItemHandlerExtern;
    private final InternalInventory sideItemHandlerExtern;
    private final InternalInventory combinedExtInventory;
    private final InternalInventory inv = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandler, this.botItemHandler, this.sideItemHandler});
    private final IUpgradeInventory upgrades = UpgradeInventories.forMachine((ItemLike)((ItemLike)AE2Things.ADVANCED_INSCRIBER.get()), (int)5, () -> ((BEAdvancedInscriber)this).saveChanges());
    private InscriberRecipe cachedTask;
    private int processingTime = 0;
    private final int maxProcessingTime = 100;
    private boolean working;

    public BEAdvancedInscriber(BlockPos pos, BlockState state) {
        super((BlockEntityType)AE2Things.ADVANCED_INSCRIBER_BE.get(), pos, state);
        this.sideItemHandler.setMaxStackSize(1, 64);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class)).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
        FilteredInventory filter = new FilteredInventory();
        this.topItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.topItemHandler, (IAEItemFilter)filter);
        this.botItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.botItemHandler, (IAEItemFilter)filter);
        this.sideItemHandlerExtern = new FilteredInternalInventory((InternalInventory)this.sideItemHandler, (IAEItemFilter)filter);
        this.combinedExtInventory = new CombinedInternalInventory(new InternalInventory[]{this.topItemHandlerExtern, this.botItemHandlerExtern, this.sideItemHandlerExtern});
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public InternalInventory getExposedInventoryForSide(Direction facing) {
        return this.combinedExtInventory;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (slot == 0) {
            boolean isEmpty = inv.getStackInSlot(0).m_41619_();
            boolean wasEmpty = this.lastStacks.get(inv).m_41619_();
            this.lastStacks.put(inv, inv.getStackInSlot(0).m_41777_());
            if (isEmpty != wasEmpty) {
                this.setProcessingTime(0);
            }
        }
        if (!this.isWorking()) {
            this.markForUpdate();
        }
        this.cachedTask = null;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean newWorking;
        boolean c = super.readFromStream(data);
        boolean oldWorking = this.isWorking();
        if (oldWorking != (newWorking = data.readBoolean()) && newWorking) {
            this.working = true;
        }
        for (int i = 0; i < this.inv.size(); ++i) {
            this.inv.setItemDirect(i, data.m_130267_());
        }
        this.cachedTask = null;
        return c;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking());
        for (int i = 0; i < this.inv.size(); ++i) {
            data.m_130055_(this.inv.getStackInSlot(i));
        }
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    @Nullable
    public InscriberRecipe getTask() {
        if (this.cachedTask == null && this.f_58857_ != null) {
            ItemStack input = ItemHandlerHelper.copyStackWithSize((ItemStack)this.sideItemHandler.getStackInSlot(0), (int)1);
            ItemStack plateA = this.topItemHandler.getStackInSlot(0);
            ItemStack plateB = this.botItemHandler.getStackInSlot(0);
            if (input.m_41619_()) {
                return null;
            }
            this.cachedTask = InscriberRecipes.findRecipe((Level)this.f_58857_, (ItemStack)input, (ItemStack)plateA, (ItemStack)plateB, (boolean)true);
        }
        return this.cachedTask;
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.upgrades.writeToNBT(data, "upgrades");
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.setProcessingTime(0);
        return false;
    }

    public boolean isWorking() {
        return this.working;
    }

    private void matchWork() {
        if (this.isWorking() != this.hasWork()) {
            this.working = this.hasWork();
            this.markForUpdate();
        }
    }

    private void setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber, this.inv.isEmpty() || !this.hasWork(), false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.matchWork();
        if (this.getTask() != null) {
            this.getMainNode().ifPresent(grid -> {
                IEnergyService eg = grid.getEnergyService();
                BEAdvancedInscriber src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD) * 3;
                int powerConsumption = 20 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    if (this.getProcessingTime() == 0) {
                        this.setProcessingTime(this.getProcessingTime() + speedFactor);
                    } else {
                        this.setProcessingTime(this.getProcessingTime() + ticksSinceLastCall * speedFactor);
                    }
                }
            });
            if (this.getProcessingTime() > this.getMaxProcessingTime()) {
                ItemStack outputCopy;
                this.setProcessingTime(this.getMaxProcessingTime());
                InscriberRecipe out = this.getTask();
                if (out != null && this.sideItemHandler.insertItem(1, outputCopy = out.m_8043_().m_41777_(), true).m_41619_()) {
                    this.sideItemHandler.insertItem(1, outputCopy, false);
                    this.setProcessingTime(0);
                    if (out.getProcessType() == InscriberProcessType.PRESS) {
                        this.topItemHandler.extractItem(0, 1, false);
                        this.botItemHandler.extractItem(0, 1, false);
                    }
                    this.sideItemHandler.extractItem(0, 1, false);
                }
            }
        }
        if (this.sideItemHandler.getStackInSlot(1).m_41720_() != Items.f_41852_) {
            ItemStack outStack = this.sideItemHandler.getStackInSlot(1);
            AEItemKey itemKey = AEItemKey.of((ItemStack)outStack);
            long inserted = this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)itemKey, (long)outStack.m_41613_(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
            this.sideItemHandler.extractItem(1, (int)inserted, false);
            this.saveChanges();
        }
        this.matchWork();
        return this.hasWork() ? TickRateModulation.URGENT : (!this.inv.isEmpty() ? TickRateModulation.SLOWER : TickRateModulation.SLEEP);
    }

    public int getMaxProcessingTime() {
        return 100;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public class FilteredInventory
    implements IAEItemFilter {
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 1;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (slot == 1) {
                return false;
            }
            if ((inv == BEAdvancedInscriber.this.topItemHandler || inv == BEAdvancedInscriber.this.botItemHandler) && AEItems.NAME_PRESS.isSameAs(stack)) {
                return true;
            }
            if (inv == BEAdvancedInscriber.this.sideItemHandler && (AEItems.NAME_PRESS.isSameAs(BEAdvancedInscriber.this.topItemHandler.getStackInSlot(0)) || AEItems.NAME_PRESS.isSameAs(BEAdvancedInscriber.this.botItemHandler.getStackInSlot(0)))) {
                return true;
            }
            ItemStack bot = BEAdvancedInscriber.this.botItemHandler.getStackInSlot(0);
            ItemStack middle = BEAdvancedInscriber.this.sideItemHandler.getStackInSlot(0);
            ItemStack top = BEAdvancedInscriber.this.topItemHandler.getStackInSlot(0);
            if (inv == BEAdvancedInscriber.this.botItemHandler) {
                bot = stack;
            }
            if (inv == BEAdvancedInscriber.this.sideItemHandler) {
                middle = stack;
            }
            if (inv == BEAdvancedInscriber.this.topItemHandler) {
                top = stack;
            }
            for (InscriberRecipe recipe : InscriberRecipes.getRecipes((Level)BEAdvancedInscriber.this.m_58904_())) {
                if (!middle.m_41619_() && !recipe.getMiddleInput().test(middle)) continue;
                if (bot.m_41619_() && top.m_41619_()) {
                    return true;
                }
                if (!(bot.m_41619_() ? recipe.getTopOptional().test(top) || recipe.getBottomOptional().test(top) : (top.m_41619_() ? recipe.getBottomOptional().test(bot) || recipe.getTopOptional().test(bot) : recipe.getTopOptional().test(top) && recipe.getBottomOptional().test(bot) || recipe.getBottomOptional().test(top) && recipe.getTopOptional().test(bot)))) continue;
                return true;
            }
            return false;
        }
    }
}

